#include "C:\\Program Files\\FED\\PIXIE\\Projects\\Master2\\master2_Auto.h"
#include <delays.h>
//#define debug
//
// Scoring machine version 1 David Coward December 2003
//
//	Version			Notes
//	=======			=====
//	1.0		This release all OK at 20Mhz.
//	1.1		Unlimited undo and modulated sound again
//	1.2		Now remembers time. Reduced transmissions.
//	1.3		Stores values associated with user buttons
//


//

//
// functions
//

void timer();
void dm();
void bin2bcd(unsigned int val);
void setup();
void display();
void display_setup();
void reset_timer();
void reset_fff();
void fff();
void sound (unsigned int duration, unsigned int freq, unsigned char mod);
void dectime();
void led_manager();
void change();
void save();
void undo();
void start_up();



//
// Variables
//

unsigned char mins, secs=30, start_mins=0, start_secs=30;
unsigned char d_count=0, modcount=0, digit=8;
unsigned char winp=0, pb=4;
unsigned char segments[17], Ds[8];
unsigned char huns, tens, units;
unsigned char score[3], user[4];
unsigned char intcount, intcount6;
unsigned char memloc=5, j, lp,ls;
unsigned char led_state;

unsigned int sound_count, duration, frequency;
unsigned int t1count=0, flashcount=0;
unsigned int correction;
unsigned int cval;

//
// structures
//

// general flags part 1

struct flag1
{
 unsigned char setup:1;
 unsigned char timeron:1;
 unsigned char runtimer:1;
 unsigned char onled:1;
 unsigned char lock:1;
 unsigned char fff:1;
 unsigned char modulate:1;
 unsigned char soundon:1;
};

flag1 flags;

// details of each score change

struct move
{
 unsigned char player;
 unsigned char points;
};

move lastmove;

// general flags part 2

struct flag2
{
 unsigned char on_message:1;
 unsigned char slave:1;
 unsigned char oldtimeron:1;
 unsigned char oldfff:1;
 unsigned char change:1;
 unsigned char s:1;
 unsigned char m:1;
 unsigned char h:1;
};

flag2 flags2;

// led struture

struct led
{
 unsigned char onoff:1;
 unsigned char state:1;
 unsigned char flash:1;
 unsigned char d:1;
 unsigned char e:1;
 unsigned char f:1;
 unsigned char g:1;
 unsigned char h:1;
};

led on_led;	// for the on_led
led p1_led;	// and team/player 1 light
led p2_led;	// team/player 2 light
led beep;	// sounder


//
// constants
//
#ifdef debug
 const sec_count=10;
#else
 const sec_count=75;
#endif
const correction_value=285;
const display_reset_time=200;
const step=10;

// C requirement. No user interupts in this design

void UserInterrupt()
{
 #asmline SETPCLATH UserIntReturn,-1; SETPCLATH for interrupt routine
 #asmline goto UserIntReturn	; PIC Assembler - go back to interrupt routine
}

//
// Initialisation
//

void UserInitialise()
{

 ADCON1=7;	// Set port A all digital
 
 TRISC=0;	// Ports B and C to be outputs
 TRISB=0;
 
#ifdef debug
#else 
 start_up();
#endif

 user[1]=1;	// user[] holds values of buttons 
 user[2]=2;	// default to 1, 2 and 4
 user[3]=4;
 
 #ifdef debug		// simulator can't do common anode
  segments[0]=0x7e;	// so set to common cathode if 
  segments[1]=0x0c;	// debug flag is set
  segments[2]=0xb6;
  segments[3]=0x9e;
  segments[4]=0xcc;
  segments[5]=0xda;
  segments[6]=0xfa;
  segments[7]=0x0e;
  segments[8]=0xfe;
  segments[9]=0xde;
  segments[10]=0xf2;	// E
  segments[11]=0xf0;	// t
  segments[12]=0x7c;	// U 
  segments[13]=0x00;
  segments[14]=0x72;	// C 
  segments[15]=0xee;	// R

 #else			// values for common anode
  segments[0]=0x80;	// for 7 segments connected to
  segments[1]=0xf2;	// PORTB bits 1 to 7 inclusive
  segments[2]=0x48;
  segments[3]=0x60;
  segments[4]=0x32;
  segments[5]=0x24;
  segments[6]=0x04;
  segments[7]=0xf0;
  segments[8]=0x00;
  segments[9]=0x20;
  segments[10]=0x0c;	// E
  segments[11]=0x0e;	// t
  segments[12]=0x82;	// U
  segments[13]=0xfe;
  segments[14]=0x8c;	// C
  segments[15]=0x10;	// R
  
 #endif
   
 flags.timeron=1;		// default to stopwatch on
 flags2.on_message=1;		// set flag for on_message
 flags2.slave=1;			// default to slave exists (not set elsewhere)
 flags2.change=1; change();	// force a change

 on_led.onoff=1;			// turn on led on
 
 if (ReadEEData(0)<100) 	// retrieve timer start times (if stored)
  {start_mins=ReadEEData(0); start_secs=ReadEEData(1);
   secs=start_secs; mins=start_mins;}
   
 if (ReadEEData(2)<100)		// retrieve user values (if stored)
  {for (j=1; j<4; j++) {user[j]=ReadEEData(j+1);}}
}

//
// Required by C complier. Not used
//

void UserLoop()
{
}

//
// Manage multiplexed display - called by interrupt event
//

void dm()   
{ 
   digit--;		// set pointer to next digit
   
   PORTC=0;		// clear driver port
   
   PORTB=segments[Ds[digit]];	// set portB to appropriate pattern
   				// as defined in the display string (Ds[])
   PORTC=PORTC|(0x01<<digit);	// turn on relevant PORTC bit
   
   if (digit==0) digit=8;	// round agin if that was the last
}

//
// Sound producer - called by interrupt event
//
//
// Trivial routine to make a noise using a ceramic resonator
// makes a square wave on a port of rough frequency and duration.
//

void Sounder()
{
 if (flags.soundon==0) return;	// no sound so straight back
 
 if (sound_count>0)		// still some cycles to go
  {
   sound_count--;		// so decrease the cycle counter
   intcount6++;			// increase intcount6 and then and it
    {if (intcount6&frequency) SoundPort|=(1<<SoundBit); // with frequecncy
     else SoundPort&=~(1<<SoundBit);} // and turn sound bit on or off as needed
  } 
 else 
  {SoundPort&=~(1<<SoundBit); flags.soundon=0;}	// turn all sound things off
}

//
// Routine to set up sound variables - called by program
//
// Main thing is to work out how many cycles the sound will be on for
//

void sound(unsigned int duration, unsigned int freq, unsigned char mod)
{
 flags.soundon=1;		// turn sound on
 frequency=freq;		// set the frequency mask
 sound_count=duration*12/4;		// multiplier 2 for 4Mhz 12 for 20 Mhz
 intcount=0;			// reset the interrupt counter
 if (mod) beep.flash=1;		// use flash utility to modulate if needed
}

//
// A key has been pressed - called by interrupt event
//

void KeyPress()   
{
 if (KP4Value==0)				    // setup key 
  {sound(20,1,0); 				    // make noise
   if (flags.setup==0) 			     	    // if not in setup mode
    {flags.setup=1; on_led.flash=1; reset_timer();} // go into it and flash on
    						    // on_led
   else						    // or exit setup 
    {on_led.flash=0; flags.setup=0; on_led.onoff=1;
     WriteEEData(0, start_mins); WriteEEData(1, start_secs); // saving times
     for (j=1; j<4; j++) WriteEEData((j+1), user[j]);}      // and key values
  }
 
 if (flags.setup) setup();	// go and set thing up if flag set
 
 else				// or do normal things
  {
   switch(KP4Value)		// test the keypad value
    {
     case 0x04 : {winp=1; fff(); break;}	// team 1 fastest finger
     
     case 0x07 : {winp=2; fff(); break;}	// team 2 fastest finger
     
     						// reset fastest finger
     case 0x03 : {if (flags.fff) {reset_fff(); sound(20,1,0);} break;}

     // **********************************************************************
     // the following cases adjust the score held in the score array (score[])
     // The max score is 99 so the routnine first checks that there's enough
     // difference to increase the points then saves the current score 
     // before changing. The score is changed by the value in the user array
     // for each user programmed button.
     //
     
     case 0x09 : {if (score[1]<99)	// Team 1 user button 1 
     		  {lp=1; ls=score[1]; save(); score[1]=score[1]+user[1];} 
     		  sound(20,1,0); break;}
     
     case 0x08 : {if (score[1]>0)	// Team 1 minus 1 point
     		  {lp=1; ls=score[1]; save(); score[1]=score[1]-1;} 
     		  sound(20,1,0); break;}
     
     case 0x0d : {if (score[2]<99)	// Team 2 user button 1
     		  {lp=2; ls=score[2]; save(); score[2]=score[2]+user[1];} 
     		  sound(20,1,0); break;}
     
     case 0x0c : {if (score[2]>0)	// Team 2 minus 1 point 
     		  {lp=2; ls=score[2]; save(); score[2]=score[2]-1;} 
     		  sound(20,1,0); break;}
      
     case 0x0a : {if (score[1]<(99-user[2])) // Team 1 user button 2 
       		  {lp=1; ls=score[1]; save(); score[1]=score[1]+user[2];} 
        	  sound(20,1,0); break;}
      
     case 0x0b : {if (score[1]<(99-user[3])) // Team 1 user button 3 
       		  {lp=1; ls=score[1]; save(); score[1]=score[1]+user[3];}
        	  sound(20,1,0); break;}
      
     case 0x0e : {if (score[2]<(99-user[2])) // Team 2 user button 2 
       		  {lp=2; ls=score[2]; save();  score[2]=score[2]+user[2];}
        	  sound(20,1,0); break;}
      
     case 0x0f : {if (score[2]<(99-user[3])); // Team 3 user button 3 
       		  {lp=2; ls=score[2]; save(); score[2]=score[2]+user[3];}
        	  sound(20,1,0); break;}      
        	  
     // score adjusting cases complete
     //********************************************************************
     
     case 0x02 : {undo(); break;}	// Undo the last score
     
     case 0x06 : {if (flags.timeron)	// start or stop the timer
     		  {if (flags.runtimer) flags.runtimer=0; // timer on so stop
     		   else {flags.runtimer=1; t1count=0;} // timer off so start
     		   sound(20,1,0);} break;}	// make noise
     		         
     case 0x05 : {if (flags.timeron)	// reset timer
     		  {reset_timer(); sound(20,1,0);} break;}
      
     case 0x01 : {score[1]=0; score[2]=0; flags.runtimer=0; // reset everything 
     		  secs=start_secs; mins=start_mins; memloc=5; 
     		  sound(20,1,0); break;}
    }
   }
 flags2.change=1;	// done something so signal a change
}


//
// Routine to work out what should be in the display array - called by program
//

void display()

{
 if (flags.setup)	// If in setup mode
  {			// display appropriate characters
   Ds[0]=5;		// 'S'
   Ds[1]=10;		// 'E'
   Ds[2]=11;		// 't'
   Ds[3]=13;		// ' '
   Ds[4]=12; 		// default to a 'U' for user buttons
   
   if (pb>3)		// or a 't' for timer if the timer button has been
    {			// pressed while in set up mode
     Ds[3]=11;		// 't'
     bin2bcd(start_mins);	// convert the minutes to bcd
     if (tens>0) Ds[4]=tens; else Ds[4]=13; // show mins digits or a space 
     if ((tens>0) || (units>0)) Ds[5]=units; else Ds[5]=13; // if they're zero
     bin2bcd(start_secs);	// convert seconds
     Ds[6]=tens;		// and put in display matrix
     Ds[7]=units;
    }
   
   else
    {
     Ds[5]=pb;		// default to user buttons. pb indicates which one
     Ds[6]=13;		// ' '
     bin2bcd(user[pb]); // convert the points value of button pb
     Ds[7]=units;	// and put it in the matrix
    }
  }

 else			// ie not in setup mode so
  {
   bin2bcd(score[1]);   // convert the first score
   Ds[0]=tens;		// and out it in the matrix
   Ds[1]=units;
   if (flags.timeron)   // if the timer is on, show the time
    {
     bin2bcd(mins);	// convert mins
     if (tens>0) Ds[2]=tens; else Ds[2]=13;	// suppress leading zeros
     if ((tens>0) || (units>0)) Ds[3]=units; else Ds[3]=13;
     bin2bcd(secs);	// convert seconds
     Ds[4]=tens;	// and add to matrix
     Ds[5]=units;
    }
   else {Ds[2]=13; Ds[3]=13; Ds[4]=13; Ds[5]=13;} // no timer so spaces instead
   bin2bcd(score[2]);	// and finally the second store
   Ds[6]=tens;		// into the matrix
   Ds[7]=units;
  }
}

//
// timer routine - called by interrupt event
//

void timer()
{
 if (flags2.on_message==1) t1count++;  // show startup message
 
 #ifdef debug
  if ((t1count>2)&&(flags2.on_message==1)) // for 2 counts in debug
 #else
  if ((t1count>40)&&(flags2.on_message==1)) // or 40 in real mode
 #endif 
   {
    flags2.on_message=0; t1count=0; flags2.change=1; // turn off msg and
   }						     // signal change
    
 if (flags.runtimer)	// is the timer running? 
 {
  t1count++;		// yes so increase the counter
  correction++;
  
 // if (correction>cval) {correction=0; t1count++;}
  
  if (t1count>sec_count)
   {
    secs--; t1count=0;
    if ((mins>0) && (secs==0xffff)) {secs=59; mins--;}
    if ((mins==0) && (secs==0xffff)) {secs=0; flags.runtimer=0;}
    flags2.change=1;
   }
 }
 display();
}

//
// Timer reset - called by program
//

void reset_timer()
{
 flags.runtimer=0; secs=start_secs; mins=start_mins;
}

//
// binary to bcd converter - called by programme
//

void bin2bcd(unsigned int val)
{
 huns=tens=units=0;	// reset output variables
 while (val>99) {huns++; val=val-100;}	// calc hundreds
 while (val>9) {tens++; val=val-10;}	// calc tens
 units=val;				// only thing left is units
}

//
// Keypresses in setup mode - called by program
//

void setup()
{
 switch (KP4Value)	// test the value
  {
   case 0x09 : pb=1; sound(20,1,0); break; // set pb to user button 1
     
   case 0x0a : pb=2; sound(20,1,0); break; // user button 2
   
   case 0x0b : pb=3; sound(20,1,0); break; // user button 3
   
   case 0x06 : pb=4; sound(20,1,0); break; // user button 4
   
   case 0x0c : {if (pb<4) {if (user[pb]>1) user[pb]--;} // decrease value of 
   							// user button
   	        else start_secs--;			// or timer seconds
   	        
   	        if (start_secs==0xffff) start_secs=59;	// set 59 if 0
   	        secs=start_secs; 
   	        sound(20,1,0); break;}
   
   case 0x0d : {if (pb<4) {if (user[pb]<9) user[pb]++;} // increase value of
   							// user button or
   							// timer seconds
   		else start_secs++;
   		
   		if (start_secs==60) start_secs=0;	// set to 0 if 60
   		secs=start_secs; 
   		sound(20,1,0); break;}
   		
   case 0x0e : {if (pb==4) {if (start_mins>0) start_mins--;} // decrease
   	        mins=start_mins; 			     // minutes if >0
   	        sound(20,1,0); break;}
   
   case 0x0f : {if (pb==4) {if (start_mins<99) start_mins++;} // increase
   		mins=start_mins; 			      // minutes if < 99
   		sound(20,1,0); break;}
  }
}

//
// test the fff enable and timer switches
//
 
void switchtest()
{
 flags2.oldtimeron=flags.timeron;	// save the old state
 
 if ((TimerPort&(1<<TimerBit))>>TimerBit) flags.timeron=1; // timer switch on 
 else flags.timeron=0;			// if not on must be off!!
 
 if (flags.timeron)			// if the switch is now on 
  {if (flags2.oldtimeron==0x00) flags2.change=1;} // and the old off must be
  						  // a change
 else					// the switch must be off so if the
  {if (flags2.oldtimeron==0x01) flags2.change=1;} // old value was on it's a
  						  // change

 flags2.oldfff=flags.fff;		// apply same logic as above to
 					// fff switch
    
 if ((ButtonPort&(1<<ButtonBit))>>ButtonBit) flags.fff=1; 
 else flags.fff=0;
 
 if (flags.fff) 
  {if (flags2.oldfff==0x00) {flags2.change=1; reset_fff();}} // but add reset
 else
  {
   if (flags2.oldfff==0x01) 
   {p1_led.onoff=0; p1_led.flash=0;		// and set the indicator leds
    p2_led.onoff=0; p2_led.flash=0;		// to flash (making sure they're
    flags2.change=1;}}				// off first) and signal change
 
}

//
// deal with fff button being pressed - called by program
//

void fff()
{
 if ((flags.fff) && (flags.lock==0)) // check fff flag on and lock state off
  {if (winp==1) 		     // number 1 is winner so
    {p1_led.onoff=1; p2_led.onoff=0; // light their light, turn off p2 light
     p1_led.flash=0; p2_led.flash=0; // stop flashing
     flags.lock=1; sound(500,2,1);}  // set the lock and make p1 noise
     
   if (winp==2) 			// set winner indicator to p2 
    {p2_led.onoff=1; p1_led.onoff=0;	// do LEDs
     p1_led.flash=0; p2_led.flash=0;
     flags.lock=1; sound(500,4,0);}	// make noise for p2
  }
}

//
// Resets fast finger flags  - called by program
//

void reset_fff()
{
 flags.lock=0; winp=0;
 p1_led.onoff=p2_led.onoff=0;
 p1_led.flash=p2_led.flash=1;
}

//
// process any changes - called by interrupt by change flag set in program
//

  
void change()
{
 if (flags2.change)	// only do something if there's a change
  {
   flags2.change=0; 	// turn off change flag
 
   display();	// no so just do normal stuff

   if (flags.setup==0)
    {
     pSerialOut(0x61);	// send 'a' for sync purposes
     for (j=0; j<8; j++) 
      {
       if (Ds[j]<10) pSerialOut(Ds[j]);
       else pSerialOut(10);
      }
    }
  }
}

//
// do things with LEDS - called by interrupt, respond according to flags set in
// structures for each LED
//

void led_manager()
{
 flashcount++;	// increase the flashcounter
 
 if ((flashcount==20)||(flashcount==40))	// set slow flash flag
  flags2.s=1;
 else flags2.s=0;
 
 if ((flashcount==10)||(flashcount==20)||(flashcount==30)||(flashcount==40))
  flags2.m=1;					// or medium 
 else flags2.m=0;
 
 if ((flashcount==5)||(flashcount==10)||(flashcount==15)||(flashcount==20)
  ||(flashcount==25)||(flashcount==30)||(flashcount==35)||(flashcount==40))
  flags2.h=1;					// or high
 else flags2.h=0;
 
 
 //
 // On LED Control - state flag shows current state of LED
 //
 
 if ((on_led.flash==1) && (flags2.s))	// check flash flag for the on LED 
  {					// (slow only)
   if (on_led.state) {on_led.state=0; on_led.onoff=0;}  // and if on, turn off
   else {on_led.state=1; on_led.onoff=1;}		// or vice versa
  } 
  
 if (on_led.onoff==0) {OnPort&=~(1<<OnBit); on_led.state=0;}	// check on/off
 else {OnPort|=(1<<OnBit); on_led.state=1;}			// and do it
   
 //
 // P1 LED Control - same as on_led but medium flash
 //
 
 if ((p1_led.flash==1) && (flags2.m)) 
  {
   if (p1_led.state) {p1_led.state=0; p1_led.onoff=0;}
   else {p1_led.state=1; p1_led.onoff=1;}
  } 
  
 if (p1_led.onoff==0) {P1Port&=~(1<<P1Bit); p1_led.state=0;}
 else {P1Port|=(1<<P1Bit); p1_led.state=1;}
  
 //
 // P2 LED Control - same as on_led but medium flash
 //
 
 if ((p2_led.flash==1) && (flags2.m))
  {
   if (p2_led.state) {p2_led.state=0; p2_led.onoff=0;}
   else {p2_led.state=1; p2_led.onoff=1;}
  }
  
 if (p2_led.onoff==0) {P2Port&=~(1<<P2Bit); p2_led.state=0;}
 else {P2Port|=(1<<P2Bit); p2_led.state=1;}
 
 if (flashcount==40) flashcount=0;
 
 //
 // beep control - used for modulation. Works same as LED control
 // but affects sound flag and sound port
 //
  
 if ((beep.flash==1) && (flags2.h))
  {
   if (beep.state) {beep.state=0; flags.soundon=0; SoundPort&=~(1<<SoundBit);}
   else {beep.state=1; flags.soundon=1;}
  }
 
 if (flashcount==40) flashcount=0; 
}

//
// writes data to EEPROM - called by program
//

void save()
{
 WriteEEData(memloc, ls); memloc++;	// last score
 WriteEEData(memloc, lp); memloc++;	// last player
}

//
// undo last scores - called by program
//

void undo()
{
 if (memloc>6)		// check there's anything to undo
  {
   memloc--;		// set pointer to last location
   lp=ReadEEData(memloc); memloc--;	// get last player
   ls=ReadEEData(memloc);		// get last score
   score[lp]=ls; sound(20,1,0);		// read it into score matrix and
  }					// make noise
}


void start_up()
{
#ifdef debug
return;
#endif
 unsigned char cycles;
 pSerialOut('r');
    
 while (cycles<10)
  {
   bRA1=1;
   Wait(200);
   bRA1=0;
   Wait(200);
   cycles++;
  }
}
